/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Properties;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.util.SupplierEx;

public class ClassUtil {
    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Class<?> loadClass(String className) {
        try {
            return ClassUtil.loadClass(null, className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static <T> T newInstance(String className) {
        return ClassUtil.newInstance(className, null);
    }

    public static <T> T newInstance(String className, Properties prop) {
        return ClassUtil.newInstance(JarClassLoader.global(), className, prop);
    }

    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return ClassUtil.newInstance(classLoader, className, null);
    }

    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        try {
            Class<?> clz = ClassUtil.loadClass(classLoader, className);
            if (clz == null) {
                return null;
            }
            return ClassUtil.newInstance(clz, prop);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static <T> T newInstance(Class<?> clz) throws Exception {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws Exception {
        if (prop == null) {
            return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return (T)clz.getConstructor(Properties.class).newInstance(prop);
    }
}

