/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.web.staticfiles.StaticLocation;
import org.noear.solon.web.staticfiles.StaticRepository;

public class StaticMappings {
    static final Map<StaticRepository, StaticLocation> locationMap = new HashMap<StaticRepository, StaticLocation>();

    public static int count() {
        return locationMap.size();
    }

    public static synchronized void add(String pathPrefix, StaticRepository repository) {
        StaticMappings.add(pathPrefix, false, repository);
    }

    public static synchronized void add(String pathPrefix, boolean repositoryIncPrefix, StaticRepository repository) {
        if (!pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        if (!pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix + "/";
        }
        locationMap.putIfAbsent(repository, new StaticLocation(pathPrefix, repository, repositoryIncPrefix));
    }

    public static synchronized void remove(StaticRepository repository) {
        locationMap.remove(repository);
    }

    public static URL find(String path) throws Exception {
        URL rst = null;
        for (StaticLocation m : locationMap.values()) {
            if (!path.startsWith(m.pathPrefix) || (rst = m.repositoryIncPrefix ? m.repository.find(path.substring(1)) : m.repository.find(path.substring(m.pathPrefix.length()))) == null) continue;
            return rst;
        }
        return rst;
    }
}

