/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.web.servlet.SolonServletContext;

class MultipartUtil {
    MultipartUtil() {
    }

    public static void buildParamsAndFiles(SolonServletContext ctx, Map<String, List<UploadedFile>> filesMap) throws IOException, ServletException {
        try {
            HttpServletRequest request = (HttpServletRequest)ctx.request();
            for (Part part : request.getParts()) {
                String name = ServerProps.urlDecode((String)part.getName());
                if (MultipartUtil.isFile(part)) {
                    MultipartUtil.doBuildFiles(name, filesMap, part);
                    continue;
                }
                ctx.paramSet(name, IoUtil.transferToString((InputStream)part.getInputStream(), (String)ServerProps.request_encoding));
            }
        }
        catch (Exception e) {
            throw new StatusException("Bad Request:" + ctx.method() + " " + ctx.pathNew(), (Throwable)e, 400);
        }
    }

    private static void doBuildFiles(String name, Map<String, List<UploadedFile>> filesMap, Part part) throws IOException {
        List<UploadedFile> list = filesMap.get(name);
        if (list == null) {
            list = new ArrayList<UploadedFile>();
            filesMap.put(name, list);
        }
        String contentType = part.getContentType();
        long contentSize = part.getSize();
        InputStream content = part.getInputStream();
        String fileName = part.getSubmittedFileName();
        String extension = null;
        int idx = fileName.lastIndexOf(".");
        if (idx > 0) {
            extension = fileName.substring(idx + 1);
        }
        UploadedFile f1 = new UploadedFile(() -> ((Part)part).delete(), contentType, contentSize, content, fileName, extension);
        list.add(f1);
    }

    private static boolean isField(Part filePart) {
        return filePart.getSubmittedFileName() == null;
    }

    private static boolean isFile(Part filePart) {
        return !MultipartUtil.isField(filePart);
    }
}

