/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation;

import java.lang.annotation.Annotation;
import org.noear.solon.Utils;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.BeanValidateInfo;
import org.noear.solon.validation.ValidatorException;
import org.noear.solon.validation.ValidatorManager;
import org.noear.solon.validation.util.FormatUtils;

public class ValidUtils {
    public static void validateContext(Context ctx) throws Throwable {
        if (ctx.getHandled()) {
            return;
        }
        Action a = ctx.action();
        if (a != null) {
            ValidatorManager.validateOfContext(ctx, a);
        }
    }

    public static void validateInvocation(Invocation inv) throws ValidatorException {
        try {
            ValidatorManager.validateOfInvocation(inv);
        }
        catch (ValidatorException e) {
            String msg = inv.method().getMethod() + " valid failed: " + e.getMessage();
            throw new ValidatorException(e.getCode(), msg, e.getAnnotation(), e.getResult(), inv.method().getMethod());
        }
        catch (Throwable e) {
            String msg = inv.method().getMethod() + " valid failed: " + e.getMessage();
            throw new ValidatorException(400, msg, null, Result.failure(), inv.method().getMethod());
        }
    }

    public static void validateEntity(Object obj, Class<?> ... groups) throws ValidatorException {
        Result rst = ValidatorManager.validateOfEntity(obj, groups);
        if (rst.getCode() == Result.FAILURE_CODE) {
            String message = null;
            Annotation anno = null;
            String label = obj.getClass().getName();
            if (Utils.isEmpty((String)rst.getDescription())) {
                rst.setDescription(label);
            }
            if (rst.getData() instanceof BeanValidateInfo) {
                BeanValidateInfo info = (BeanValidateInfo)((Object)rst.getData());
                anno = info.anno;
                message = info.message;
            }
            String msg = FormatUtils.format(anno, rst, message);
            throw new ValidatorException(rst.getCode(), msg, null, rst);
        }
    }
}

