/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.DecimalMin;
import org.noear.solon.validation.util.StringUtils;

public class DecimalMinValidator
implements Validator<DecimalMin> {
    public static final DecimalMinValidator instance = new DecimalMinValidator();

    @Override
    public String message(DecimalMin anno) {
        return anno.message();
    }

    @Override
    public Result validateOfEntity(Class<?> clz, DecimalMin anno, String name, Object val0, StringBuilder tmp) {
        if (!(val0 instanceof Double)) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        Double val = (Double)val0;
        if (val == null || val < anno.value()) {
            return Result.failure((String)(clz.getSimpleName() + "." + name));
        }
        return Result.succeed();
    }

    @Override
    public Result validateOfContext(Context ctx, DecimalMin anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!StringUtils.isNumber(val) || Double.parseDouble(val) < anno.value()) {
            return Result.failure((String)name);
        }
        return Result.succeed();
    }
}

