/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.validation.annotation;

import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Result;
import org.noear.solon.validation.Validator;
import org.noear.solon.validation.annotation.DecimalMax;
import org.noear.solon.validation.util.StringUtils;

public class DecimalMaxValidator
implements Validator<DecimalMax> {
    public static final DecimalMaxValidator instance = new DecimalMaxValidator();

    @Override
    public String message(DecimalMax anno) {
        return anno.message();
    }

    @Override
    public Result validate(Context ctx, DecimalMax anno, String name, StringBuilder tmp) {
        String val = ctx.param(name);
        if (!StringUtils.isNumber(val) || Double.parseDouble(val) > anno.value()) {
            tmp.append(',').append(name);
        }
        if (tmp.length() > 1) {
            return Result.failure((String)tmp.substring(1));
        }
        return Result.succeed();
    }
}

