/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.socketd;

import java.net.URI;
import java.util.function.Supplier;
import org.noear.nami.Channel;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Nami;
import org.noear.nami.channel.socketd.SocketChannel;
import org.noear.solon.annotation.Note;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.Connector;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionFactoryManager;
import org.noear.solon.socketd.protocol.MessageProtocol;

public class SocketD {
    public static void setProtocol(MessageProtocol protocol) {
        ProtocolManager.setProtocol(protocol);
    }

    public static Session createSession(Connector connector) {
        return SessionFactoryManager.create(connector);
    }

    @Note(value="ServerUri \u4ee5\uff1aws:// \u6216 wss:// \u6216 tcp:// \u5f00\u5934")
    public static Session createSession(URI serverUri, boolean autoReconnect) {
        return SessionFactoryManager.create(serverUri, autoReconnect);
    }

    @Note(value="ServerUri \u4ee5\uff1aws:// \u6216 wss:// \u6216 tcp:// \u5f00\u5934")
    public static Session createSession(URI serverUri) {
        return SocketD.createSession(serverUri, true);
    }

    @Note(value="ServerUri \u4ee5\uff1aws:// \u6216 wss:// \u6216 tcp:// \u5f00\u5934")
    public static Session createSession(String serverUri, boolean autoReconnect) {
        return SocketD.createSession(URI.create(serverUri), autoReconnect);
    }

    @Note(value="ServerUri \u4ee5\uff1aws:// \u6216 wss:// \u6216 tcp:// \u5f00\u5934")
    public static Session createSession(String serverUri) {
        return SocketD.createSession(serverUri, true);
    }

    public static <T> T create(URI serverUri, Class<T> service) {
        Session session = SocketD.createSession(serverUri, true);
        return SocketD.create(() -> session, service);
    }

    public static <T> T create(URI serverUri, Encoder encoder, Decoder decoder, Class<T> service) {
        Session session = SocketD.createSession(serverUri, true);
        return SocketD.create(() -> session, encoder, decoder, service);
    }

    public static <T> T create(String serverUri, Class<T> service) {
        Session session = SocketD.createSession(serverUri, true);
        return SocketD.create(() -> session, service);
    }

    public static <T> T create(String serverUri, Encoder encoder, Decoder decoder, Class<T> service) {
        Session session = SocketD.createSession(serverUri, true);
        return SocketD.create(() -> session, encoder, decoder, service);
    }

    public static <T> T create(Context context, Class<T> service) {
        if (context.request() instanceof Session) {
            Session session = (Session)context.request();
            return SocketD.create(() -> session, null, null, service);
        }
        throw new IllegalArgumentException("Request context nonsupport socketd");
    }

    public static <T> T create(Session session, Class<T> service) {
        return SocketD.create(() -> session, service);
    }

    public static <T> T create(Supplier<Session> sessions, Class<T> service) {
        return SocketD.create(sessions, null, null, service);
    }

    public static <T> T create(Session session, Encoder encoder, Decoder decoder, Class<T> service) {
        return SocketD.create(() -> session, encoder, decoder, service);
    }

    public static <T> T create(Supplier<Session> sessions, Encoder encoder, Decoder decoder, Class<T> service) {
        URI uri = sessions.get().uri();
        if (uri == null) {
            uri = URI.create("tcp://socketd");
        }
        String server = uri.getScheme() + ":" + uri.getSchemeSpecificPart();
        return (T)Nami.builder().encoder(encoder).decoder(decoder).headerSet("Accept", "application/json").headerSet("Content-Type", "application/json").channel((Channel)new SocketChannel(sessions)).upstream(() -> server).create(service);
    }
}

