/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.redisson;

import java.util.Properties;
import org.noear.solon.Solon;
import org.noear.solon.core.Props;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateFactory;
import org.noear.solon.sessionstate.redisson.RedissonBuilder;
import org.noear.solon.sessionstate.redisson.RedissonSessionState;
import org.redisson.api.RedissonClient;

public class RedissonSessionStateFactory
implements SessionStateFactory {
    private static RedissonSessionStateFactory instance;
    private RedissonClient redisClient;
    public static final int SESSION_STATE_PRIORITY = 2;

    public static RedissonSessionStateFactory getInstance() {
        if (instance == null) {
            instance = new RedissonSessionStateFactory();
        }
        return instance;
    }

    private RedissonSessionStateFactory() {
        Props prop = Solon.cfg().getProp("server.session.state.redis");
        if (prop.size() < 4) {
            System.err.println("Error configuration: solon.session.state.redis");
            return;
        }
        this.redisClient = RedissonBuilder.build((Properties)prop);
    }

    protected RedissonClient redisClient() {
        return this.redisClient;
    }

    public int priority() {
        return 2;
    }

    public SessionState create(Context ctx) {
        return new RedissonSessionState(ctx);
    }
}

