/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.snack3;

import org.noear.snack.core.Feature;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;
import org.noear.solon.serialization.snack3.SnackActionExecutor;
import org.noear.solon.serialization.snack3.SnackRenderFactory;
import org.noear.solon.serialization.snack3.SnackRenderTypedFactory;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) {
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        SnackRenderFactory renderFactory = new SnackRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(SnackRenderFactory.class, (Object)renderFactory);
        EventBus.push((Object)renderFactory);
        SnackRenderTypedFactory renderTypedFactory = new SnackRenderTypedFactory();
        context.wrapAndPut(SnackRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(-99, () -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        SnackActionExecutor actionExecutor = new SnackActionExecutor();
        context.wrapAndPut(SnackActionExecutor.class, (Object)actionExecutor);
        EventBus.push((Object)((Object)actionExecutor));
        Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)actionExecutor);
    }

    private void applyProps(SnackRenderFactory factory, JsonProps jsonProps) {
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            if (jsonProps.nullStringAsEmpty) {
                factory.addFeatures(Feature.StringNullAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                factory.addFeatures(Feature.BooleanNullAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                factory.addFeatures(Feature.NumberNullAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                factory.addFeatures(Feature.ArrayNullAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                factory.addFeatures(Feature.SerializeNulls);
            }
            if (jsonProps.enumAsName) {
                factory.addFeatures(Feature.EnumUsingName);
            }
        }
    }
}

