/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.noear.snack.ONode;
import org.noear.snack.core.NameValues;
import org.noear.snack.core.Options;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.serialization.ContextSerializer;

public class PropertiesStringSerializer
implements ContextSerializer<String> {
    private Options config;

    public Options getConfig() {
        if (this.config == null) {
            this.config = Options.def();
        }
        return this.config;
    }

    public void setConfig(Options config) {
        if (config != null) {
            this.config = config;
        }
    }

    public String getContentType() {
        return "application/properties";
    }

    public boolean matched(Context ctx, String mime) {
        return false;
    }

    public String name() {
        return "properties-string";
    }

    public String serialize(Object obj) throws IOException {
        ONode oNode = ONode.loadObj((Object)obj, (Options)this.getConfig());
        Properties oProperties = (Properties)oNode.toObject(Properties.class);
        StringBuilder buf = new StringBuilder();
        ArrayList<String> bufKeys = new ArrayList<String>(oProperties.stringPropertyNames());
        bufKeys.sort(String::compareTo);
        for (String key : bufKeys) {
            buf.append(key).append("=").append(oProperties.getProperty(key)).append("\n");
        }
        return buf.toString();
    }

    public Object deserialize(String data, Class<?> clz) throws IOException {
        Properties prop = Utils.buildProperties((String)data);
        if (clz == null) {
            return prop;
        }
        ONode oNode = ONode.loadObj((Object)prop, (Options)this.getConfig());
        return oNode.toObject(clz);
    }

    public void serializeToBody(Context ctx, Object data) throws IOException {
        ctx.contentType(this.getContentType());
        if (data instanceof ModelAndView) {
            ctx.output(this.serialize(((ModelAndView)data).model()));
        } else {
            ctx.output(this.serialize(data));
        }
    }

    public Object deserializeFromBody(Context ctx) throws IOException {
        NameValues nameValues = new NameValues();
        for (Map.Entry kv : ctx.paramsMap().entrySet()) {
            for (String val : (List)kv.getValue()) {
                nameValues.add((String)kv.getKey(), val);
            }
        }
        return ONode.loadObj((Object)nameValues, (Options)this.getConfig());
    }
}

