/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.jackson.JacksonActionExecutor;
import org.noear.solon.serialization.jackson.JacksonRenderFactory;
import org.noear.solon.serialization.jackson.JacksonRenderTypedFactory;
import org.noear.solon.serialization.jackson.NullValueSerializer;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) {
        JsonProps jsonProps = JsonProps.create((AppContext)context);
        JacksonRenderFactory renderFactory = new JacksonRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(JacksonRenderFactory.class, (Object)renderFactory);
        EventBus.publish((Object)renderFactory);
        JacksonRenderTypedFactory renderTypedFactory = new JacksonRenderTypedFactory();
        context.wrapAndPut(JacksonRenderTypedFactory.class, (Object)renderTypedFactory);
        context.lifecycle(-94, () -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        JacksonActionExecutor actionExecutor = new JacksonActionExecutor();
        context.wrapAndPut(JacksonActionExecutor.class, (Object)actionExecutor);
        EventBus.publish((Object)((Object)actionExecutor));
        Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)actionExecutor);
    }

    private void applyProps(JacksonRenderFactory factory, JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (writeNulls) {
                factory.config().getSerializerProvider().setNullValueSerializer((JsonSerializer)new NullValueSerializer(jsonProps));
            }
            if (jsonProps.enumAsName) {
                factory.config().configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
            }
        }
        if (!writeNulls) {
            factory.config().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        factory.config().configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true);
        factory.config().configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        factory.config().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        factory.config().configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        factory.config().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        factory.config().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        factory.config().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        factory.config().configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
    }
}

