/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.serialization.jackson.TypeReferenceImp;

public class JacksonActionExecutor
extends ActionExecutorDefault {
    private static final String label = "/json";
    ObjectMapper mapper_type = new ObjectMapper();

    public JacksonActionExecutor() {
        this.mapper_type.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.mapper_type.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper_type.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        this.mapper_type.activateDefaultTypingAsProperty(this.mapper_type.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.OBJECT_AND_NON_CONCRETE, "@type");
    }

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx) throws Exception {
        return this.mapper_type.readTree(ctx.bodyNew());
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (bodyObj == null) {
            return null;
        }
        if (ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        JsonNode tmp = (JsonNode)bodyObj;
        if (tmp.isObject()) {
            if (tmp.has(p.getName())) {
                JsonNode m1 = tmp.get(p.getName());
                return this.mapper_type.readValue(this.mapper_type.treeAsTokens((TreeNode)m1), new TypeReferenceImp(p));
            }
            if (ctx.paramMap().containsKey((Object)p.getName())) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            return this.mapper_type.readValue(this.mapper_type.treeAsTokens((TreeNode)tmp), new TypeReferenceImp(p));
        }
        if (tmp.isArray()) {
            return this.mapper_type.readValue(this.mapper_type.treeAsTokens((TreeNode)tmp), new TypeReferenceImp(p));
        }
        return this.mapper_type.readValue(this.mapper_type.treeAsTokens((TreeNode)tmp), new TypeReferenceImp(p));
    }
}

