/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.nio.charset.Charset;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.serialization.ActionSerializer;

public class Fastjson2BytesSerializer
implements ActionSerializer<byte[]> {
    private JSONWriter.Context serializeConfig;
    private JSONReader.Context deserializeConfig;
    private Charset charset = Charset.forName(Solon.encoding());

    public JSONWriter.Context getSerializeConfig() {
        if (this.serializeConfig == null) {
            this.serializeConfig = new JSONWriter.Context(new ObjectWriterProvider());
        }
        return this.serializeConfig;
    }

    public void cfgSerializeFeatures(boolean isReset, boolean isAdd, JSONWriter.Feature ... features) {
        if (isReset) {
            this.getSerializeConfig().setFeatures(0L);
        }
        for (JSONWriter.Feature feature : features) {
            this.getSerializeConfig().config(feature, isAdd);
        }
    }

    public JSONReader.Context getDeserializeConfig() {
        if (this.deserializeConfig == null) {
            this.deserializeConfig = new JSONReader.Context(new ObjectReaderProvider());
        }
        return this.deserializeConfig;
    }

    public void cfgDeserializeFeatures(boolean isReset, boolean isAdd, JSONReader.Feature ... features) {
        if (isReset) {
            this.getDeserializeConfig().setFeatures(0L);
        }
        for (JSONReader.Feature feature : features) {
            this.getDeserializeConfig().config(feature, isAdd);
        }
    }

    public String name() {
        return "fastjson2-jsonb";
    }

    public byte[] serialize(Object obj) throws IOException {
        return JSON.toJSONBytes((Object)obj, (Charset)this.charset, (JSONWriter.Context)this.getSerializeConfig());
    }

    public Object deserialize(byte[] data, Class<?> clz) throws IOException {
        if (clz == null) {
            return JSON.parse((byte[])data, (JSONReader.Context)this.getDeserializeConfig());
        }
        return JSON.parseObject((byte[])data, clz, (JSONReader.Context)this.getDeserializeConfig());
    }

    public Object deserializeBody(Context ctx) throws IOException {
        byte[] data = ctx.bodyAsBytes();
        return JSON.parse((byte[])data, (JSONReader.Context)this.getDeserializeConfig());
    }
}

