/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSONWriter;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.fastjson2.Fastjson2ActionExecutor;
import org.noear.solon.serialization.fastjson2.Fastjson2RenderFactory;
import org.noear.solon.serialization.fastjson2.Fastjson2RenderTypedFactory;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public static boolean output_meta = false;

    public void start(AopContext context) {
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        Fastjson2RenderFactory renderFactory = new Fastjson2RenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(Fastjson2RenderFactory.class, (Object)renderFactory);
        EventBus.push((Object)renderFactory);
        Fastjson2RenderTypedFactory renderTypedFactory = new Fastjson2RenderTypedFactory();
        context.wrapAndPut(Fastjson2RenderTypedFactory.class, (Object)renderTypedFactory);
        context.beanOnloaded(x -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        Fastjson2ActionExecutor actionExecutor = new Fastjson2ActionExecutor();
        context.wrapAndPut(Fastjson2ActionExecutor.class, (Object)actionExecutor);
        EventBus.push((Object)((Object)actionExecutor));
        Bridge.actionExecutorAdd((ActionExecutor)actionExecutor);
    }

    private void applyProps(Fastjson2RenderFactory factory, JsonProps jsonProps) {
        boolean writeNulls = false;
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            boolean bl = writeNulls = jsonProps.nullAsWriteable || jsonProps.nullNumberAsZero || jsonProps.nullArrayAsEmpty || jsonProps.nullBoolAsFalse || jsonProps.nullStringAsEmpty;
            if (jsonProps.nullStringAsEmpty) {
                factory.addFeatures(JSONWriter.Feature.WriteNullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                factory.addFeatures(JSONWriter.Feature.WriteNullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                factory.addFeatures(JSONWriter.Feature.WriteNullNumberAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                factory.addFeatures(JSONWriter.Feature.WriteNullListAsEmpty);
            }
            if (writeNulls) {
                factory.addFeatures(JSONWriter.Feature.WriteNulls);
            }
        }
    }
}

