/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import org.noear.solon.serialization.StringSerializer;

public class Fastjson2Serializer
implements StringSerializer {
    ObjectWriterProvider config;
    JSONWriter.Feature[] features;

    protected Fastjson2Serializer(ObjectWriterProvider config, JSONWriter.Feature ... features) {
        this.config = config;
        this.features = features;
    }

    public String serialize(Object obj) throws IOException {
        if (this.config == null) {
            return JSON.toJSONString((Object)obj, (JSONWriter.Feature[])this.features);
        }
        return this.toJSONString2(obj);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String toJSONString2(Object object) {
        JSONWriter.Context context = new JSONWriter.Context(this.config, this.features);
        try (JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);){
            if (object == null) {
                writer.writeNull();
            } else {
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
        catch (NullPointerException | NumberFormatException e) {
            throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", (Throwable)e);
        }
    }
}

