/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.SerializerFeature;
import org.noear.solon.Solon;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.fastjson.FastjsonActionExecutor;
import org.noear.solon.serialization.fastjson.FastjsonRenderFactory;
import org.noear.solon.serialization.fastjson.FastjsonRenderTypedFactory;
import org.noear.solon.serialization.prop.JsonProps;
import org.noear.solon.serialization.prop.JsonPropsUtil;

public class XPluginImp
implements Plugin {
    public static boolean output_meta = false;

    public void start(AopContext context) {
        output_meta = Solon.cfg().getInt("solon.output.meta", 0) > 0;
        JsonProps jsonProps = JsonProps.create((AopContext)context);
        FastjsonRenderFactory renderFactory = new FastjsonRenderFactory();
        this.applyProps(renderFactory, jsonProps);
        context.wrapAndPut(FastjsonRenderFactory.class, (Object)renderFactory);
        EventBus.push((Object)renderFactory);
        FastjsonRenderTypedFactory renderTypedFactory = new FastjsonRenderTypedFactory();
        context.wrapAndPut(FastjsonRenderTypedFactory.class, (Object)renderTypedFactory);
        context.beanOnloaded(x -> {
            RenderManager.mapping((String)"@json", (Render)renderFactory.create());
            RenderManager.mapping((String)"@type_json", (Render)renderTypedFactory.create());
        });
        FastjsonActionExecutor actionExecutor = new FastjsonActionExecutor();
        context.wrapAndPut(FastjsonActionExecutor.class, (Object)actionExecutor);
        EventBus.push((Object)((Object)actionExecutor));
        Bridge.actionExecutorAdd((ActionExecutor)actionExecutor);
    }

    private void applyProps(FastjsonRenderFactory factory, JsonProps jsonProps) {
        if (JsonPropsUtil.apply((JsonRenderFactory)factory, (JsonProps)jsonProps)) {
            if (jsonProps.nullStringAsEmpty) {
                factory.addFeatures(SerializerFeature.WriteNullStringAsEmpty);
            }
            if (jsonProps.nullBoolAsFalse) {
                factory.addFeatures(SerializerFeature.WriteNullBooleanAsFalse);
            }
            if (jsonProps.nullNumberAsZero) {
                factory.addFeatures(SerializerFeature.WriteNullNumberAsZero);
            }
            if (jsonProps.nullArrayAsEmpty) {
                factory.addFeatures(SerializerFeature.WriteNullListAsEmpty);
            }
            if (jsonProps.nullAsWriteable) {
                factory.addFeatures(SerializerFeature.WriteMapNullValue);
            }
        }
    }
}

