/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.noear.solon.core.handle.ActionExecutorDefault;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.wrap.ParamWrap;

public class FastjsonJsonActionExecutor
extends ActionExecutorDefault {
    private static final String label = "/json";

    public boolean matched(Context ctx, String ct) {
        return ct != null && ct.contains(label);
    }

    protected Object changeBody(Context ctx) throws Exception {
        return JSON.parse((String)ctx.bodyNew());
    }

    protected Object changeValue(Context ctx, ParamWrap p, int pi, Class<?> pt, Object bodyObj) throws Exception {
        if (bodyObj == null) {
            return null;
        }
        if (ctx.paramMap().containsKey((Object)p.getName())) {
            return super.changeValue(ctx, p, pi, pt, bodyObj);
        }
        if (bodyObj instanceof JSONObject) {
            JSONObject tmp = (JSONObject)bodyObj;
            if (tmp.containsKey((Object)p.getName())) {
                ParameterizedType gp = p.getGenericType();
                if (gp != null) {
                    return tmp.getObject(p.getName(), (Type)gp);
                }
                return tmp.getObject(p.getName(), pt);
            }
            if (ctx.paramMap().containsKey((Object)p.getName())) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            if (pt.isPrimitive() || pt.getTypeName().startsWith("java.lang.")) {
                return super.changeValue(ctx, p, pi, pt, bodyObj);
            }
            ParameterizedType gp = p.getGenericType();
            if (gp != null) {
                return tmp.toJavaObject((Type)gp);
            }
            return tmp.toJavaObject(pt);
        }
        if (bodyObj instanceof JSONArray) {
            JSONArray tmp = (JSONArray)bodyObj;
            if (!Collection.class.isAssignableFrom(pt)) {
                return null;
            }
            ParameterizedType gp = p.getGenericType();
            if (gp != null) {
                return tmp.toJavaObject((Type)gp);
            }
            return tmp.toJavaObject(p.getType());
        }
        return bodyObj;
    }
}

