/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.serialization.fastjson;

import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeWriter;
import org.noear.solon.serialization.JsonLongConverter;
import org.noear.solon.serialization.JsonRenderFactory;
import org.noear.solon.serialization.JsonStringConverter;

public abstract class FastjsonRenderFactoryBase
implements JsonRenderFactory {
    protected abstract SerializeConfig config();

    public <T> void addEncoder(Class<T> clz, ObjectSerializer encoder) {
        this.config().put(clz, encoder);
    }

    public <T> void addConvertor(Class<T> clz, JsonLongConverter<T> converter) {
        this.addEncoder(clz, (ser, obj, fieldName, fieldType, features) -> {
            SerializeWriter out = ser.getWriter();
            out.writeLong(converter.convert(obj).longValue());
        });
    }

    public <T> void addConvertor(Class<T> clz, JsonStringConverter<T> converter) {
        this.addEncoder(clz, (ser, obj, fieldName, fieldType, features) -> {
            SerializeWriter out = ser.getWriter();
            out.writeString(converter.convert(obj));
        });
    }
}

