/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.command;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.scheduling.command.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandManager {
    private static Logger log = LoggerFactory.getLogger(CommandManager.class);
    private Map<String, CommandExecutor> executorMap = new LinkedHashMap<String, CommandExecutor>();

    public static CommandManager getInstance() {
        return (CommandManager)Solon.context().attachmentOf(CommandManager.class, CommandManager::new);
    }

    public void register(String command, CommandExecutor executor) {
        this.executorMap.put(command, executor);
    }

    public boolean exists(String command) {
        return this.executorMap.containsKey(command);
    }

    public void execute(String command) throws Throwable {
        CommandExecutor executor = this.executorMap.get(command);
        if (executor != null) {
            executor.execute(command);
        }
    }

    public void executeAll() {
        for (Map.Entry<String, CommandExecutor> kv : this.executorMap.entrySet()) {
            if (!Solon.cfg().argx().containsKey((Object)kv.getKey())) continue;
            try {
                kv.getValue().execute(kv.getKey());
            }
            catch (Throwable e) {
                log.warn("Command execute failed, cmd={}", (Object)kv.getKey(), (Object)e);
            }
        }
    }
}

