/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.async;

import org.noear.solon.core.AopContext;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.scheduling.annotation.Async;
import org.noear.solon.scheduling.async.InvocationRunnable;
import org.noear.solon.scheduling.async.InvocationRunnableFactory;

public class AsyncInterceptor
implements Interceptor {
    InvocationRunnableFactory runnableFactory;

    public AsyncInterceptor(AopContext context) {
        context.getBeanAsync(InvocationRunnableFactory.class, bean -> {
            this.runnableFactory = bean;
        });
    }

    public Object doIntercept(Invocation inv) throws Throwable {
        Async anno = (Async)inv.method().getAnnotation(Async.class);
        if (anno != null) {
            Runnable runnable = this.createRunnable(inv);
            if (runnable != null) {
                RunUtil.async((Runnable)runnable);
            }
            return null;
        }
        return inv.invoke();
    }

    private Runnable createRunnable(Invocation inv) {
        if (this.runnableFactory == null) {
            return new InvocationRunnable(inv);
        }
        return this.runnableFactory.create(inv);
    }
}

