/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz.integration;

import java.lang.reflect.Method;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.scheduling.ScheduledAnno;
import org.noear.solon.scheduling.annotation.Scheduled;
import org.noear.solon.scheduling.quartz.AbstractJob;
import org.noear.solon.scheduling.quartz.JobManager;
import org.noear.solon.scheduling.quartz.integration.BeanJob;
import org.noear.solon.scheduling.quartz.integration.MethodJob;
import org.noear.solon.scheduling.utils.ScheduledHelper;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class QuartzBeanBuilder
implements BeanBuilder<Scheduled>,
BeanExtractor<Scheduled> {
    private final AopContext context;

    public QuartzBeanBuilder(AopContext context) {
        this.context = context;
    }

    public void doBuild(Class<?> clz, BeanWrap bw, Scheduled anno) throws Throwable {
        if (!(bw.raw() instanceof Job) && !(bw.raw() instanceof Runnable)) {
            throw new IllegalStateException("Quartz job only supports Runnable or Job types!");
        }
        ScheduledAnno warpper = new ScheduledAnno(anno);
        ScheduledHelper.configScheduled((ScheduledAnno)warpper);
        BeanJob job = new BeanJob(bw);
        String name = Utils.annoAlias((String)warpper.name(), (String)((AbstractJob)job).getJobId());
        JobManager.addJob(name, (Scheduled)warpper, job);
    }

    public void doExtract(BeanWrap bw, Method method, Scheduled anno) throws Throwable {
        Class<?> tmp;
        if (method.getParameterCount() > 1) {
            throw new IllegalStateException("Scheduling quartz job supports only one JobExecutionContext parameter!");
        }
        if (method.getParameterCount() == 1 && (tmp = method.getParameterTypes()[0]) != JobExecutionContext.class) {
            throw new IllegalStateException("Scheduling quartz supports only one JobExecutionContext parameter!");
        }
        ScheduledAnno warpper = new ScheduledAnno(anno);
        ScheduledHelper.configScheduled((ScheduledAnno)warpper);
        MethodJob job = new MethodJob(bw, method);
        String name = Utils.annoAlias((String)warpper.name(), (String)((AbstractJob)job).getJobId());
        JobManager.addJob(name, (Scheduled)warpper, job);
    }
}

