/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.scheduling.quartz.integration;

import java.lang.reflect.Method;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.scheduling.quartz.AbstractJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MethodJob
extends AbstractJob {
    private final String jobId;
    private final BeanWrap target;
    private MethodWrap method;
    private final boolean isRunnable;

    public MethodJob(BeanWrap target, Method method) {
        this.target = target;
        this.method = target.context().methodGet(method);
        this.isRunnable = method.getParameterCount() == 0;
        this.jobId = target.clz().getName() + "::" + method.getName();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            if (this.isRunnable) {
                this.method.invokeByAspect(this.target.get(), new Object[0]);
            } else {
                this.method.invokeByAspect(this.target.get(), new Object[]{context});
            }
        }
        catch (Throwable e) {
            throw new JobExecutionException(e);
        }
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }
}

