/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.proxy.aot.AotProxy;
import org.noear.solon.proxy.asm.AsmProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BeanInvocationHandler.class);
    private Class<?> clazz;
    private Object target;
    private Object proxy;
    private InvocationHandler handler;
    private final AppContext context;

    public BeanInvocationHandler(AppContext context, Object target, InvocationHandler handler) {
        this(context, target.getClass(), target, handler);
    }

    public BeanInvocationHandler(AppContext context, Class<?> clazz, Object target, InvocationHandler handler) {
        this.context = context;
        this.target = target;
        this.handler = handler;
        this.clazz = clazz;
        if (NativeDetector.isNotAotRuntime()) {
            this.proxy = AotProxy.newProxyInstance(context, this, clazz);
        }
        if (this.proxy == null) {
            this.proxy = AsmProxy.newProxyInstance(context, this, clazz);
        }
        if (Solon.cfg().isDebugMode() && this.proxy != null) {
            log.trace("Proxy class:" + this.proxy.getClass().getName());
        }
    }

    public Object getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.handler == null) {
            method.setAccessible(true);
            Object result = this.context.methodGet(this.clazz, method).invokeByAspect(this.target, args);
            return result;
        }
        return this.handler.invoke(this.target, method, args);
    }
}

