/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.proxy.asm;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.proxy.asm.MethodDigest;
import org.noear.solon.proxy.asm.MethodFinder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetClassVisitor
extends ClassVisitor {
    static final Logger log = LoggerFactory.getLogger(TargetClassVisitor.class);
    private boolean isFinal;
    private List<MethodDigest> methods = new ArrayList<MethodDigest>();
    private List<MethodDigest> declaredMethods = new ArrayList<MethodDigest>();
    private List<MethodDigest> constructors = new ArrayList<MethodDigest>();
    private final ClassLoader classLoader;

    public TargetClassVisitor(ClassLoader classLoader, ClassReader reader) {
        super(589824);
        this.classLoader = classLoader;
        reader.accept((ClassVisitor)this, 2);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        List<MethodDigest> beans;
        super.visit(version, access, name, signature, superName, interfaces);
        if ((access & 0x10) == 16) {
            this.isFinal = true;
        }
        if (superName != null && (beans = this.initMethodBeanByParent(superName)) != null && !beans.isEmpty()) {
            for (MethodDigest bean : beans) {
                if (this.methods.contains(bean)) continue;
                this.methods.add(bean);
            }
        }
        if (interfaces != null) {
            for (String ifType : interfaces) {
                List<MethodDigest> beans2 = this.initMethodBeanByParent(ifType);
                if (beans2 == null || beans2.isEmpty()) continue;
                for (MethodDigest bean : beans2) {
                    if (this.methods.contains(bean)) continue;
                    this.methods.add(bean);
                }
            }
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            MethodDigest constructor = new MethodDigest(access, name, descriptor);
            this.constructors.add(constructor);
        } else if (!"<clinit>".equals(name) && MethodFinder.allowMethod(access)) {
            MethodDigest methodDigest = new MethodDigest(access, name, descriptor);
            if (!this.declaredMethods.contains(methodDigest)) {
                this.declaredMethods.add(methodDigest);
            }
            if (!this.methods.contains(methodDigest)) {
                this.methods.add(methodDigest);
            }
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public List<MethodDigest> getMethods() {
        return this.methods;
    }

    public List<MethodDigest> getDeclaredMethods() {
        return this.declaredMethods;
    }

    public List<MethodDigest> getConstructors() {
        return this.constructors;
    }

    private List<MethodDigest> initMethodBeanByParent(String superName) {
        block17: {
            try {
                ClassReader reader;
                if (!Utils.isNotEmpty((String)superName)) break block17;
                if (superName.equals("java/lang/Object")) {
                    return null;
                }
                URL superNameUrl = this.classLoader.getResource(superName.replace('.', '/') + ".class");
                if (superNameUrl == null) {
                    throw new IOException("Class not found: " + superName);
                }
                try (InputStream in = superNameUrl.openStream();){
                    reader = new ClassReader(in);
                }
                TargetClassVisitor visitor = new TargetClassVisitor(this.classLoader, reader);
                ArrayList<MethodDigest> digests = new ArrayList<MethodDigest>();
                for (MethodDigest methodDigest : visitor.methods) {
                    if (!MethodFinder.allowMethod(methodDigest.access)) continue;
                    digests.add(methodDigest);
                }
                return digests;
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

