/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.logging;

import org.noear.solon.Solon;
import org.noear.solon.logging.LogAppender;
import org.noear.solon.logging.event.AppenderSimple;
import org.noear.solon.logging.event.Level;
import org.noear.solon.logging.event.LogEvent;

public abstract class LogAbstractAppender
extends AppenderSimple
implements LogAppender {
    private boolean enable = true;
    private Level level;

    public LogAbstractAppender() {
        String levelStr = Solon.cfg().get("solon.logging.appender." + this.getName() + ".level");
        this.setLevel(Level.of(levelStr, this.getDefaultLevel()));
        this.enable = Solon.cfg().getBool("solon.logging.appender." + this.getName() + ".enable", true);
    }

    @Override
    public boolean getEnable() {
        return this.enable;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public void append(LogEvent logEvent) {
        if (!this.enable || this.level.code > this.level.code) {
            return;
        }
        this.appendDo(logEvent);
    }
}

