/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Produces;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.handle.Context;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.openapi2.BasicAuthUtils;
import org.noear.solon.docs.openapi2.Swagger2Builder;
import org.noear.solon.docs.openapi2.Swagger2Resource;

public class Swagger2Controller {
    @Inject
    AopContext aopContext;

    @Produces(value="application/json; charset=utf-8")
    @Mapping(value="swagger-resources")
    public List<Swagger2Resource> resources() {
        List list = this.aopContext.getWrapsOfType(DocDocket.class);
        return list.stream().filter(bw -> Utils.isNotEmpty((String)bw.name())).map(bw -> new Swagger2Resource(bw.name(), ((DocDocket)bw.raw()).groupName())).collect(Collectors.toList());
    }

    @Produces(value="application/json; charset=utf-8")
    @Mapping(value="swagger/v2")
    public String api(Context ctx, String group) throws IOException {
        DocDocket docket = (DocDocket)this.aopContext.getBean(group);
        if (docket == null) {
            return null;
        }
        if (!BasicAuthUtils.basicAuth(ctx, docket)) {
            BasicAuthUtils.response401(ctx);
            return null;
        }
        if (!docket.globalResponseCodes().containsKey(200)) {
            docket.globalResponseCodes().put(200, "");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Swagger swagger = new Swagger2Builder(docket).build();
        return mapper.writeValueAsString((Object)swagger);
    }
}

