/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs;

import io.swagger.models.ExternalDocs;
import io.swagger.models.Scheme;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.docs.ApiInfo;
import org.noear.solon.docs.ApiResource;
import org.noear.solon.docs.ApiVendorExtension;

public class DocDocket {
    private String version = "2.0";
    private List<Scheme> schemes = new ArrayList<Scheme>();
    private String groupName = "default";
    private String host;
    private String basePath;
    private Map<String, String> basicAuth = new LinkedHashMap<String, String>();
    private Class<?> globalResult;
    private Map<Integer, String> globalResponseCodes = new LinkedHashMap<Integer, String>();
    private boolean globalResponseInData = false;
    private ApiInfo info = new ApiInfo();
    private List<ApiResource> apis = new ArrayList<ApiResource>();
    private Map<String, SecuritySchemeDefinition> securityDefinitions = new LinkedHashMap<String, SecuritySchemeDefinition>();
    private ExternalDocs externalDocs;
    private Map<String, Object> vendorExtensions = new LinkedHashMap<String, Object>();

    public String version() {
        return this.version;
    }

    public String host() {
        return this.host;
    }

    public DocDocket host(String host) {
        this.host = host;
        return this;
    }

    public List<Scheme> schemes() {
        return this.schemes;
    }

    public DocDocket schemes(String ... schemes) {
        for (String s : schemes) {
            Scheme scheme = Scheme.forValue((String)s);
            if (scheme == null) continue;
            this.schemes.add(scheme);
        }
        return this;
    }

    public String groupName() {
        return this.groupName;
    }

    public DocDocket groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String basePath() {
        return this.basePath;
    }

    public DocDocket basePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, String> basicAuth() {
        return this.basicAuth;
    }

    public DocDocket basicAuth(String username, String password) {
        this.basicAuth.put(username, password);
        return this;
    }

    public List<ApiResource> apis() {
        return this.apis;
    }

    public DocDocket apis(String basePackage) {
        this.apis.add(new ApiResource(basePackage));
        return this;
    }

    public DocDocket apis(ApiResource apiResource) {
        this.apis.add(apiResource);
        return this;
    }

    public ApiInfo info() {
        return this.info;
    }

    public DocDocket info(ApiInfo info) {
        this.info = info;
        return this;
    }

    public boolean globalResponseInData() {
        return this.globalResponseInData;
    }

    public DocDocket globalResponseInData(boolean globalResponseInData) {
        this.globalResponseInData = globalResponseInData;
        return this;
    }

    public Map<Integer, String> globalResponseCodes() {
        return this.globalResponseCodes;
    }

    public DocDocket globalResponseCodes(Map<Integer, String> globalResponseCodes) {
        if (globalResponseCodes != null) {
            this.globalResponseCodes.putAll(globalResponseCodes);
        }
        return this;
    }

    public Class<?> globalResult() {
        return this.globalResult;
    }

    public DocDocket globalResult(Class<?> clz) {
        this.globalResult = clz;
        return this;
    }

    public Map<String, SecuritySchemeDefinition> securityDefinitions() {
        return this.securityDefinitions;
    }

    public DocDocket securityDefinition(String name, SecuritySchemeDefinition securityDefinition) {
        this.securityDefinitions.put(name, securityDefinition);
        return this;
    }

    public DocDocket securityDefinitionInHeader(String name) {
        this.securityDefinitions.put(name, (SecuritySchemeDefinition)new ApiKeyAuthDefinition().in(In.HEADER));
        return this;
    }

    public DocDocket securityDefinitionInQuery(String name) {
        this.securityDefinitions.put(name, (SecuritySchemeDefinition)new ApiKeyAuthDefinition().in(In.QUERY));
        return this;
    }

    public ExternalDocs externalDocs() {
        return this.externalDocs;
    }

    public DocDocket externalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Map<String, Object> vendorExtensions() {
        return this.vendorExtensions;
    }

    public DocDocket vendorExtensions(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null) {
            this.vendorExtensions.putAll(vendorExtensions);
        }
        return this;
    }

    public DocDocket vendorExtensions(String name, Object value) {
        this.vendorExtensions.put(name, value);
        return this;
    }

    public DocDocket vendorExtensions(ApiVendorExtension vendorExtension) {
        if (vendorExtension != null) {
            this.vendorExtensions.put(vendorExtension.getName(), vendorExtension.getValue());
        }
        return this;
    }
}

