/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.openapi2.impl;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiParam;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.docs.openapi2.wrap.ApiImplicitParamImpl;
import org.noear.solon.docs.openapi2.wrap.ApiParamAnno;
import org.noear.solon.docs.openapi2.wrap.ApiParamImpl;

public class ParamHolder {
    private ParamWrap param;
    private ApiParamAnno anno;

    public ParamHolder(ParamWrap param) {
        ApiParam tmp;
        this.param = param;
        if (param != null && (tmp = param.getParameter().getAnnotation(ApiParam.class)) != null) {
            this.anno = new ApiParamImpl(tmp);
        }
    }

    public ParamHolder binding(ApiImplicitParamImpl anno) {
        if (anno != null) {
            this.anno = anno;
        }
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public ParamWrap getParam() {
        return this.param;
    }

    public ApiImplicitParam getAnno() {
        return this.anno;
    }

    public String getName() {
        if (this.param != null) {
            return this.param.getName();
        }
        if (this.anno != null) {
            return this.anno.name();
        }
        return null;
    }

    public String getDescription() {
        if (this.anno != null) {
            return this.anno.value();
        }
        return null;
    }

    public boolean isMap() {
        if (this.param != null) {
            return Map.class.isAssignableFrom(this.param.getType());
        }
        return false;
    }

    public boolean isArray() {
        if (this.param != null) {
            return Collection.class.isAssignableFrom(this.param.getType());
        }
        return false;
    }

    public String dataType() {
        if (this.param != null) {
            if (UploadedFile.class.equals((Object)this.param.getType())) {
                return "file";
            }
            return this.param.getType().getSimpleName();
        }
        String tmp = null;
        if (this.anno != null && Utils.isEmpty((String)(tmp = this.anno.dataType())) && this.anno.dataTypeClass() != Void.class) {
            tmp = this.anno.dataTypeClass().getSimpleName();
        }
        if (Utils.isBlank(tmp)) {
            return "String";
        }
        return tmp;
    }

    public Class<?> dataTypeClass() {
        if (this.param != null) {
            return this.param.getType();
        }
        if (this.anno != null) {
            return this.anno.dataTypeClass();
        }
        return null;
    }

    public Type dataGenericType() {
        if (this.param != null) {
            return this.param.getGenericType();
        }
        return null;
    }

    public String paramType() {
        if (this.param != null && this.param.isRequiredBody()) {
            return "body";
        }
        String tmp = null;
        if (this.anno != null) {
            tmp = this.anno.paramType();
        }
        if (Utils.isBlank(tmp)) {
            return "query";
        }
        return tmp;
    }

    public boolean allowMultiple() {
        if (this.param != null) {
            return this.param.getType().isArray() || Collection.class.isAssignableFrom(this.param.getType());
        }
        if (this.anno != null) {
            return this.anno.allowMultiple();
        }
        return false;
    }

    public boolean hidden() {
        if (this.anno != null) {
            return this.anno.hidden();
        }
        return false;
    }

    public boolean isRequired() {
        if (this.param != null && this.param.isRequiredInput()) {
            return true;
        }
        if (this.anno != null) {
            return this.anno.required();
        }
        return false;
    }

    public boolean isRequiredBody() {
        boolean tmp = false;
        if (this.param != null) {
            tmp = this.param.isRequiredBody();
        }
        if (!tmp && this.anno != null) {
            tmp = "body".equals(this.anno.paramType());
        }
        return tmp;
    }

    public boolean isRequiredHeader() {
        boolean tmp = false;
        if (this.param != null) {
            tmp = this.param.isRequiredHeader();
        }
        if (!tmp && this.anno != null) {
            tmp = "header".equals(this.anno.paramType());
        }
        return tmp;
    }

    public boolean isRequiredCookie() {
        boolean tmp = false;
        if (this.param != null) {
            return this.param.isRequiredCookie();
        }
        if (!tmp && this.anno != null) {
            tmp = "cookie".equals(this.anno.paramType());
        }
        return tmp;
    }

    public boolean isRequiredPath() {
        boolean tmp = false;
        if (this.param != null) {
            return this.param.isRequiredPath();
        }
        if (!tmp && this.anno != null) {
            tmp = "path".equals(this.anno.paramType());
        }
        return tmp;
    }

    public boolean isReadOnly() {
        if (this.anno != null) {
            return this.anno.readOnly();
        }
        return false;
    }

    public boolean isIgnore() {
        if (this.param != null) {
            if (Context.class.equals((Object)this.param.getType())) {
                return true;
            }
            if (SessionState.class.equals((Object)this.param.getType())) {
                return true;
            }
        }
        return this.hidden();
    }
}

