/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.integration;

import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.aspect.MethodInterceptor;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheServiceWrapConsumer;
import org.noear.solon.data.cache.LocalCacheFactoryImpl;
import org.noear.solon.data.cache.LocalCacheService;
import org.noear.solon.data.cache.interceptor.CacheInterceptor;
import org.noear.solon.data.cache.interceptor.CachePutInterceptor;
import org.noear.solon.data.cache.interceptor.CacheRemoveInterceptor;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.data.tran.interceptor.TranInterceptor;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) {
        Map<String, DataSource> dsmap;
        Props props;
        CacheLib.cacheFactoryAdd("local", new LocalCacheFactoryImpl());
        if (Solon.app().enableTransaction()) {
            context.beanInterceptorAdd(Tran.class, (MethodInterceptor)TranInterceptor.instance, 120);
        }
        if (Solon.app().enableCaching()) {
            CacheLib.cacheServiceAddIfAbsent("", LocalCacheService.instance);
            context.subWrapsOfType(CacheService.class, (Consumer)new CacheServiceWrapConsumer());
            context.lifecycle(-94, () -> {
                if (!context.hasWrap(CacheService.class)) {
                    context.wrapAndPut(CacheService.class, (Object)LocalCacheService.instance);
                }
            });
            context.beanInterceptorAdd(CachePut.class, (MethodInterceptor)new CachePutInterceptor(), 110);
            context.beanInterceptorAdd(CacheRemove.class, (MethodInterceptor)new CacheRemoveInterceptor(), 110);
            context.beanInterceptorAdd(Cache.class, (MethodInterceptor)new CacheInterceptor(), 111);
        }
        if ((props = Solon.cfg().getProp("solon.dataSources")).size() > 0 && (dsmap = DsUtils.buildDsMap((Properties)props, null, new String[]{"class"})).size() > 0) {
            for (Map.Entry<String, DataSource> kv : dsmap.entrySet()) {
                boolean typed = false;
                String name = kv.getKey();
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                    typed = true;
                }
                BeanWrap dsBw = context.wrap(name, (Object)kv.getValue());
                context.putWrap(name, dsBw);
                if (typed) {
                    context.putWrap(DataSource.class, dsBw);
                }
                context.wrapPublish(dsBw);
            }
        }
    }
}

