/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheTagsService;

public class CacheTagsServiceImpl
implements CacheTagsService {
    private static final String TAG_SECONDS = "{{s}}:";
    private CacheService _cache;

    public CacheTagsServiceImpl(CacheService caching) {
        this._cache = caching;
    }

    protected List<String> _get(String tag) {
        ArrayList temp = this._cache.get(tag, ArrayList.class);
        if (temp == null) {
            return new ArrayList<String>();
        }
        return temp;
    }

    protected void _set(String tag, List<String> keyList, int seconds) {
        this._cache.store(tag, keyList, seconds);
    }

    protected String _tagKey(String tag) {
        return ("@" + tag).toUpperCase();
    }

    @Override
    public <T> T get(String key, Class<T> clz) {
        return this._cache.get(key, clz);
    }

    @Override
    public void remove(String key) {
        this._cache.remove(key);
    }

    @Override
    public void removeTag(String ... tags) {
        for (String tag : tags) {
            String tagKey = this._tagKey(tag);
            List<String> cacheKeyList = this._get(tagKey);
            for (String cacheKey : cacheKeyList) {
                if (cacheKey.startsWith(TAG_SECONDS)) continue;
                this._cache.remove(cacheKey);
            }
            this._cache.remove(tagKey);
        }
    }

    @Override
    public void store(String key, Object obj, int seconds) {
        this._cache.store(key, obj, seconds);
    }

    @Override
    public void storeTag(String key, Object obj, int seconds, String ... tags) {
        this._cache.store(key, obj, seconds);
        for (String tag : tags) {
            this.update(key, tag, obj, seconds);
        }
    }

    protected void update(String key, String tag, Object newValue, int refSeconds) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        if (cacheKeyList.contains(key)) {
            if (newValue == null) {
                this._cache.remove(key);
            } else {
                Object temp = this._cache.get(key, newValue.getClass());
                if (temp != null && newValue.getClass() == temp.getClass()) {
                    this._cache.store(key, newValue, refSeconds);
                }
            }
        }
        int seconds = refSeconds;
        if (cacheKeyList.size() > 0) {
            String secondsStr = cacheKeyList.get(0);
            if (secondsStr.startsWith(TAG_SECONDS)) {
                seconds = Integer.parseInt(secondsStr.substring(TAG_SECONDS.length()));
                if (refSeconds > seconds) {
                    seconds = refSeconds;
                    cacheKeyList.remove(0);
                    cacheKeyList.add(0, TAG_SECONDS + seconds);
                }
            } else {
                cacheKeyList.add(0, TAG_SECONDS + seconds);
            }
        } else {
            cacheKeyList.add(0, TAG_SECONDS + seconds);
        }
        cacheKeyList.add(key);
        this._set(tagKey, cacheKeyList, seconds);
    }
}

