/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.tran.TranExecutor;

public class TranUtils {
    private static TranExecutor executor = () -> false;

    public static void execute(Tran tran, RunnableEx runnable) throws Throwable {
        executor.execute(tran, runnable);
    }

    public static boolean inTrans() {
        return executor.inTrans();
    }

    public static boolean inTransAndReadOnly() {
        return executor.inTransAndReadOnly();
    }

    public static Connection getConnection(DataSource ds) throws SQLException {
        return executor.getConnection(ds);
    }

    static {
        Solon.context().getBeanAsync(TranExecutor.class, bean -> {
            executor = bean;
        });
    }
}

