/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;

public class DsUtils {
    private static Class<?> resolveType(Properties props) {
        String typeStr = props.getProperty("type");
        if (Utils.isEmpty((String)typeStr)) {
            throw new IllegalStateException("Missing type configuration");
        }
        props.remove("type");
        Class typeClz = Utils.loadClass((String)typeStr);
        if (typeClz == null || !DataSource.class.isAssignableFrom(typeClz)) {
            throw new IllegalStateException("Type configuration not is data source");
        }
        return typeClz;
    }

    public static DataSource buildDs(Properties props) {
        Class<?> typeClz = DsUtils.resolveType(props);
        return DsUtils.buildDs(props, typeClz);
    }

    public static DataSource buildDs(Properties props, Class<?> typeClz) {
        return (DataSource)PropsConverter.global().convert(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props) {
        Class<?> typeClz = DsUtils.resolveType(props);
        return DsUtils.buildDsMap(props, typeClz);
    }

    public static Map<String, DataSource> buildDsMap(Properties props, Class<?> typeClz) {
        Props rootProps;
        if (props instanceof Props) {
            rootProps = (Props)props;
        } else {
            rootProps = new Props();
            rootProps.putAll((Map)props);
        }
        Map groupProps = rootProps.getGroupedProp("");
        if (groupProps.size() == 0) {
            throw new IllegalStateException("Missing data source configuration");
        }
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        groupProps.forEach((key, prop) -> {
            if (prop.size() > 1) {
                DataSource source = (DataSource)PropsConverter.global().convert((Properties)prop, typeClz);
                dataSourceMap.put((String)key, source);
            }
        });
        return dataSourceMap;
    }
}

