/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.cache.CacheService;

public class CacheTags {
    private CacheService _cache;

    public CacheTags(CacheService caching) {
        this._cache = caching;
    }

    public void add(String tag, String targetCacheKey) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        if (cacheKeyList.contains(targetCacheKey)) {
            return;
        }
        cacheKeyList.add(targetCacheKey);
        this._set(tagKey, cacheKeyList);
    }

    public CacheTags remove(String tag) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        for (String cacheKey : cacheKeyList) {
            this._cache.remove(cacheKey);
        }
        this._cache.remove(tagKey);
        return this;
    }

    public void update(String tag, Object newValue, int seconds) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        for (String cacheKey : cacheKeyList) {
            Object temp = this._cache.get(cacheKey);
            if (temp == null) continue;
            if (newValue == null) {
                this._cache.remove(cacheKey);
                continue;
            }
            if (newValue.getClass() != temp.getClass()) continue;
            this._cache.store(cacheKey, newValue, seconds);
        }
    }

    protected List<String> _get(String tagKey) {
        Object temp = this._cache.get(tagKey);
        if (temp == null) {
            return new ArrayList<String>();
        }
        return (List)temp;
    }

    protected void _set(String tagKey, List<String> value) {
        this._cache.store(tagKey, value, 0);
    }

    protected String _tagKey(String tag) {
        return ("@" + tag).toUpperCase();
    }
}

