/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tranImp;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.tran.TranManager;
import org.noear.solon.data.tran.TranNode;
import org.noear.solon.data.tranImp.DbTranNode;
import org.noear.solon.ext.RunnableEx;

public abstract class DbTran
extends DbTranNode
implements TranNode {
    private final Tran meta;
    private final Map<DataSource, Connection> conMap = new HashMap<DataSource, Connection>();

    public Tran getMeta() {
        return this.meta;
    }

    public Connection getConnection(DataSource ds) throws SQLException {
        if (this.conMap.containsKey(ds)) {
            return this.conMap.get(ds);
        }
        Connection con = ds.getConnection();
        con.setAutoCommit(false);
        con.setReadOnly(this.meta.readOnly());
        if (this.meta.isolation().level > 0) {
            con.setTransactionIsolation(this.meta.isolation().level);
        }
        this.conMap.putIfAbsent(ds, con);
        return con;
    }

    public DbTran(Tran meta) {
        this.meta = meta;
    }

    public void execute(RunnableEx runnable) throws Throwable {
        try {
            TranManager.currentSet(this);
            runnable.run();
            if (this.parent == null) {
                this.commit();
            }
        }
        catch (Throwable ex) {
            if (this.parent == null) {
                this.rollback();
            }
            throw Utils.throwableUnwrap((Throwable)ex);
        }
        finally {
            TranManager.currentRemove();
            if (this.parent == null) {
                this.close();
            }
        }
    }

    @Override
    public void commit() throws Throwable {
        super.commit();
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            kv.getValue().commit();
        }
    }

    @Override
    public void rollback() throws Throwable {
        super.rollback();
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            kv.getValue().rollback();
        }
    }

    @Override
    public void close() throws Throwable {
        super.close();
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            try {
                if (kv.getValue().isClosed()) continue;
                kv.getValue().close();
            }
            catch (Throwable ex) {
                EventBus.push((Object)ex);
            }
        }
    }
}

