/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.Properties;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.LocalCacheService;

public class CacheServiceProxy
implements CacheService {
    private CacheService real;
    private String driverType;

    public CacheService getReal() {
        return this.real;
    }

    public String getDriverType() {
        return this.driverType;
    }

    public CacheServiceProxy(Properties prop) {
        String driverType = prop.getProperty("driverType");
        if ("local".equals(driverType)) {
            this.real = new LocalCacheService(prop);
        } else if ("redis".equals(driverType)) {
            this.real = this.newInstance("org.noear.solon.cache.jedis.RedisCacheService", prop);
        } else if ("memcached".equals(driverType)) {
            this.real = this.newInstance("org.noear.solon.cache.spymemcached.MemCacheService", prop);
        } else {
            throw new IllegalArgumentException("There is no supported driver type");
        }
    }

    private CacheService newInstance(String clzName, Properties prop) {
        try {
            Class clz = Utils.loadClass((String)clzName);
            if (clz == null) {
                throw new ClassNotFoundException(clzName);
            }
            return (CacheService)Utils.newInstance((Class)clz, (Properties)prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void store(String key, Object obj, int seconds) {
        this.real.store(key, obj, seconds);
    }

    @Override
    public Object get(String key) {
        return this.real.get(key);
    }

    @Override
    public void remove(String key) {
        this.real.remove(key);
    }
}

