/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.noear.solon.data.cache.CacheService;

public class LocalCacheService
implements CacheService {
    public static CacheService instance = new LocalCacheService();
    private int _defaultSeconds;
    private Map<String, Entity> _data = new ConcurrentHashMap<String, Entity>();
    private static ScheduledExecutorService _exec = Executors.newSingleThreadScheduledExecutor();

    public LocalCacheService() {
        this(300);
    }

    public LocalCacheService(int defSeconds) {
        this._defaultSeconds = defSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(String key, Object obj, int seconds) {
        if (seconds == 0) {
            seconds = this.getDefalutSeconds();
        }
        String string = key.intern();
        synchronized (string) {
            Entity ent = this._data.get(key);
            if (ent == null) {
                ent = new Entity(obj);
                this._data.put(key, ent);
            } else {
                ent.value = obj;
                ent.futureDel();
            }
            if (seconds > 0) {
                ent.future = _exec.schedule(() -> this._data.remove(key), (long)seconds, TimeUnit.SECONDS);
            }
        }
    }

    @Override
    public Object get(String key) {
        Entity ent = this._data.get(key);
        return ent == null ? null : ent.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        String string = key.intern();
        synchronized (string) {
            Entity ent = this._data.remove(key);
            if (ent != null) {
                ent.futureDel();
            }
        }
    }

    public void clear() {
        for (Entity ent : this._data.values()) {
            ent.futureDel();
        }
        this._data.clear();
    }

    public int getDefalutSeconds() {
        return this._defaultSeconds;
    }

    private static class Entity {
        public Object value;
        public Future future;

        public Entity(Object val) {
            this.value = val;
        }

        protected void futureDel() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
        }
    }
}

