/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Utils;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheTags;
import org.noear.solon.ext.SupplierEx;

public class CacheExecutorImp {
    public static final CacheExecutorImp global = new CacheExecutorImp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cache(Cache anno, Method method, ParamWrap[] params, Object[] values, SupplierEx executor) throws Throwable {
        if (anno == null) {
            return executor.get();
        }
        Map<String, Object> parMap = this.buildParamsMap(params, values);
        Object result = null;
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        String key = anno.key();
        key = Utils.isEmpty((String)key) ? this.buildCacheKey(method, parMap) : this.formatTagsOrKey(key, parMap);
        String keyLock = key + ":lock";
        String string = keyLock.intern();
        synchronized (string) {
            result = cs.get(key);
            if (result == null && (result = executor.get()) != null) {
                cs.store(key, result, anno.seconds());
                if (Utils.isNotEmpty((String)anno.tags())) {
                    String tags = this.formatTagsOrKey(anno.tags(), parMap);
                    CacheTags ct = new CacheTags(cs);
                    for (String tag : tags.split(",")) {
                        ct.add(tag, key);
                    }
                }
            }
            return result;
        }
    }

    public void cacheRemove(CacheRemove anno, Method method, ParamWrap[] params, Object[] values) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        Map<String, Object> parMap = this.buildParamsMap(params, values);
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = this.formatTagsOrKey(anno.tags(), parMap);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.remove(tag);
            }
        }
        if (Utils.isNotEmpty((String)anno.key())) {
            String key = this.formatTagsOrKey(anno.key(), parMap);
            cs.remove(key);
        }
    }

    public void cachePut(CachePut anno, Method method, ParamWrap[] params, Object[] values, Object newValue) {
        if (anno == null) {
            return;
        }
        CacheService cs = CacheLib.cacheServiceGet(anno.service());
        Map<String, Object> parMap = this.buildParamsMap(params, values);
        if (Utils.isNotEmpty((String)anno.tags())) {
            String tags = this.formatTagsOrKey(anno.tags(), parMap);
            CacheTags ct = new CacheTags(cs);
            for (String tag : tags.split(",")) {
                ct.update(tag, newValue, anno.seconds());
            }
        }
        if (Utils.isNotEmpty((String)anno.key())) {
            String key = this.formatTagsOrKey(anno.key(), parMap);
            cs.store(key, newValue, anno.seconds());
        }
    }

    protected Map<String, Object> buildParamsMap(ParamWrap[] params, Object[] values) {
        LinkedHashMap<String, Object> parMap = new LinkedHashMap<String, Object>();
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            parMap.put(params[i].getName(), values[i]);
        }
        return parMap;
    }

    protected String buildCacheKey(Method method, Map<String, Object> parMap) {
        StringBuilder keyB = new StringBuilder();
        keyB.append(method.getDeclaringClass().getName()).append(":");
        keyB.append(method.getName()).append(":");
        parMap.forEach((k, v) -> keyB.append((String)k).append("_").append(v));
        return keyB.toString();
    }

    protected String formatTagsOrKey(String str, Map map) {
        if (str.indexOf("$") < 0) {
            return str;
        }
        String str2 = str;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher m = pattern.matcher(str);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (!map.containsKey(name)) continue;
            String val = String.valueOf(map.get(name));
            str2 = str2.replace(mark, val);
        }
        return str2;
    }
}

