/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.cache.CacheService;

public class CacheTags {
    private static final String TAG_SECONDS = "{{s}}:";
    private CacheService _cache;

    public CacheTags(CacheService caching) {
        this._cache = caching;
    }

    public void add(String tag, String targetCacheKey, int refSeconds) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        if (cacheKeyList.contains(targetCacheKey)) {
            return;
        }
        int seconds = refSeconds;
        if (cacheKeyList.size() > 0) {
            String secondsStr = cacheKeyList.get(0);
            if (secondsStr.startsWith(TAG_SECONDS)) {
                seconds = Integer.parseInt(secondsStr.substring(TAG_SECONDS.length()));
                if (refSeconds > seconds) {
                    seconds = refSeconds;
                    cacheKeyList.remove(0);
                    cacheKeyList.add(0, TAG_SECONDS + seconds);
                }
            } else {
                cacheKeyList.add(0, TAG_SECONDS + seconds);
            }
        } else {
            cacheKeyList.add(0, TAG_SECONDS + seconds);
        }
        cacheKeyList.add(targetCacheKey);
        this._set(tagKey, cacheKeyList, seconds);
    }

    public CacheTags remove(String tag) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        for (String cacheKey : cacheKeyList) {
            if (cacheKey.startsWith(TAG_SECONDS)) continue;
            this._cache.remove(cacheKey);
        }
        this._cache.remove(tagKey);
        return this;
    }

    public void update(String tag, Object newValue, int seconds) {
        String tagKey = this._tagKey(tag);
        List<String> cacheKeyList = this._get(tagKey);
        for (String cacheKey : cacheKeyList) {
            Object temp;
            if (cacheKey.startsWith(TAG_SECONDS) || (temp = this._cache.get(cacheKey)) == null) continue;
            if (newValue == null) {
                this._cache.remove(cacheKey);
                continue;
            }
            if (newValue.getClass() != temp.getClass()) continue;
            this._cache.store(cacheKey, newValue, seconds);
        }
    }

    protected List<String> _get(String tagKey) {
        Object temp = this._cache.get(tagKey);
        if (temp == null) {
            return new ArrayList<String>();
        }
        return (List)temp;
    }

    protected void _set(String tagKey, List<String> value, int seconds) {
        this._cache.store(tagKey, value, seconds);
    }

    protected String _tagKey(String tag) {
        return ("@" + tag).toUpperCase();
    }
}

