/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.noear.solon.Utils;

public abstract class AbstractRoutingDataSource
implements DataSource,
Closeable {
    private DataSource defaultTargetDataSource;
    private Map<String, DataSource> targetDataSources;
    private boolean strict;

    public void setTargetDataSources(Map<String, DataSource> targetDataSources) {
        if (targetDataSources == null || targetDataSources.size() == 0) {
            throw new IllegalArgumentException("Property 'targetDataSources' is required");
        }
        this.targetDataSources = targetDataSources;
    }

    public void setDefaultTargetDataSource(DataSource defaultTargetDataSource) {
        if (defaultTargetDataSource == null) {
            throw new IllegalArgumentException("Property 'defaultTargetDataSource' is required");
        }
        this.defaultTargetDataSource = defaultTargetDataSource;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    protected abstract String determineCurrentKey();

    protected DataSource determineCurrentTarget() {
        String targetKey = this.determineCurrentKey();
        if (Utils.isEmpty((String)targetKey)) {
            return this.defaultTargetDataSource;
        }
        DataSource tmp = this.targetDataSources.get(targetKey);
        if (tmp == null) {
            if (this.strict) {
                throw new IllegalStateException("Cannot determine target DataSource for key [" + targetKey + "]");
            }
            tmp = this.defaultTargetDataSource;
        }
        return tmp;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.determineCurrentTarget().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineCurrentTarget().getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)(iface.isInstance(this) ? this : this.determineCurrentTarget().unwrap(iface));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this) || this.determineCurrentTarget().isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.determineCurrentTarget().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.determineCurrentTarget().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.determineCurrentTarget().setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.determineCurrentTarget().getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.determineCurrentTarget().getParentLogger();
    }

    @Override
    public void close() throws IOException {
        if (this.defaultTargetDataSource != null && this.defaultTargetDataSource instanceof Closeable) {
            ((Closeable)((Object)this.defaultTargetDataSource)).close();
        }
        if (this.targetDataSources != null) {
            for (DataSource ds : this.targetDataSources.values()) {
                if (!(ds instanceof Closeable)) continue;
                ((Closeable)((Object)ds)).close();
            }
        }
    }
}

