/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.Solon;
import org.noear.solon.cloud.model.Instance;

public class Discovery
implements Serializable {
    private final String group;
    private final String service;
    private final List<Instance> cluster;
    private String agent;
    private String policy;
    private transient Object attachment;

    public <T> T attachment() {
        return (T)this.attachment;
    }

    public <T> void attachmentSet(T val) {
        this.attachment = val;
    }

    @Deprecated
    public Discovery(String service) {
        this(Solon.cfg().appGroup(), service);
    }

    public Discovery(String group, String service) {
        this.group = group;
        this.service = service;
        this.cluster = new ArrayList<Instance>();
    }

    public String group() {
        return this.group;
    }

    public String service() {
        return this.service;
    }

    public String agent() {
        return this.agent;
    }

    public Discovery agent(String agent) {
        this.agent = agent;
        return this;
    }

    public String policy() {
        return this.policy;
    }

    public Discovery policy(String policy) {
        this.policy = policy;
        return this;
    }

    public List<Instance> cluster() {
        return this.cluster;
    }

    public int clusterSize() {
        return this.cluster.size();
    }

    public Discovery instanceAdd(Instance instance) {
        this.cluster.add(instance);
        return this;
    }

    public Instance instanceGet(int index) {
        return this.cluster.get(index % this.cluster.size());
    }

    public String toString() {
        return "Discovery{group='" + this.group + '\'' + ", service='" + this.service + '\'' + ", policy='" + this.policy + '\'' + ", agent='" + this.agent + '\'' + ", cluster=" + this.cluster + '}';
    }
}

