/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.CloudEventInterceptor;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.exception.CloudEventException;
import org.noear.solon.cloud.impl.CloudEventServiceManager;
import org.noear.solon.cloud.model.Event;
import org.noear.solon.cloud.service.CloudEventServicePlus;

public class CloudEventServiceManagerImpl
implements CloudEventServiceManager {
    Map<String, CloudEventServicePlus> route = new HashMap<String, CloudEventServicePlus>();
    CloudEventInterceptor eventInterceptor;

    public CloudEventServiceManagerImpl() {
        Solon.context().getBeanAsync(CloudEventInterceptor.class, bean -> {
            this.eventInterceptor = bean;
        });
    }

    @Override
    public CloudEventInterceptor getEventInterceptor() {
        return this.eventInterceptor;
    }

    @Override
    public void register(CloudEventServicePlus service) {
        if (service.getChannel() == null) {
            this.route.put("", service);
        } else {
            this.route.put(service.getChannel(), service);
        }
    }

    @Override
    public CloudEventServicePlus get(String channel) {
        if (channel == null) {
            channel = "";
        }
        return this.route.get(channel);
    }

    @Override
    public CloudEventServicePlus getOrThrow(String channel) {
        CloudEventServicePlus tmp = this.get(channel);
        if (tmp == null) {
            if (Utils.isEmpty((String)channel)) {
                throw new IllegalStateException("CloudEventService does not exist");
            }
            throw new IllegalStateException("CloudEventService does not exist channel &" + channel);
        }
        return tmp;
    }

    @Override
    public boolean publish(Event event) throws CloudEventException {
        CloudEventServicePlus tmp = this.getOrThrow(event.channel());
        if (Utils.isEmpty((String)event.group())) {
            event.group(tmp.getGroup());
        }
        if (Utils.isEmpty((String)event.key())) {
            event.key(Utils.guid());
        }
        return tmp.publish(event);
    }

    @Override
    public void attention(EventLevel level, String channel, String group, String topic, String tag, int qos, CloudEventHandler observer) {
        CloudEventServicePlus tmp = this.getOrThrow(channel);
        if (Utils.isEmpty((String)group)) {
            group = tmp.getGroup();
        }
        tmp.attention(level, channel, group, topic, tag, qos, observer);
    }
}

