/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.cloud.CloudEventHandler;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.model.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventObserver
implements CloudEventHandler {
    static Logger log = LoggerFactory.getLogger(EventObserver.class);
    private EventLevel level;
    private String group;
    private String topic;
    private List<CloudEventHandler> handlers;

    public EventObserver(EventLevel level, String group, String topic) {
        this.level = level;
        this.group = group;
        this.topic = topic;
        this.handlers = new ArrayList<CloudEventHandler>();
    }

    public void addHandler(CloudEventHandler handler) {
        this.handlers.add(handler);
    }

    @Override
    public boolean handler(Event event) throws Throwable {
        boolean isOk = true;
        boolean isHandled = false;
        for (CloudEventHandler h1 : this.handlers) {
            isOk = isOk && h1.handler(event);
            isHandled = true;
        }
        if (!isHandled) {
            log.warn("There is no handler for this event topic[{}]", (Object)event.topic());
        }
        return isOk;
    }
}

