/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.exception.CloudFileException;

public class Media {
    private final InputStream body;
    private final String contentType;

    public Media(InputStream body, String contentType) {
        this.body = body;
        this.contentType = contentType;
    }

    public Media(InputStream body) {
        this(body, null);
    }

    public Media(byte[] body, String contentType) {
        this(new ByteArrayInputStream(body), contentType);
    }

    public Media(byte[] body) {
        this(body, null);
    }

    public Media(String body, String contentType) {
        this(body.getBytes(StandardCharsets.UTF_8), contentType);
    }

    public Media(String body) {
        this(body, null);
    }

    public String contentType() {
        return this.contentType;
    }

    public InputStream body() {
        return this.body;
    }

    public byte[] bodyAsByts() {
        try {
            return Utils.transferToBytes((InputStream)this.body);
        }
        catch (IOException e) {
            throw new CloudFileException(e);
        }
    }

    public String bodyAsString() {
        try {
            return Utils.transferToString((InputStream)this.body, (String)Solon.encoding());
        }
        catch (IOException e) {
            throw new CloudFileException(e);
        }
    }
}

