/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.Solon;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.handle.Context;
import org.noear.solon.ext.DataThrowable;

public class CloudBreakerInterceptor
implements Interceptor {
    public static final CloudBreakerInterceptor instance = new CloudBreakerInterceptor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doIntercept(Invocation inv) throws Throwable {
        if (CloudClient.breaker() == null) {
            throw new IllegalArgumentException("Missing CloudBreakerService component");
        }
        CloudBreaker anno = (CloudBreaker)inv.method().getAnnotation(CloudBreaker.class);
        if (anno == null) return inv.invoke();
        String name = Solon.cfg().getByParse(anno.value());
        try (AutoCloseable entry = CloudClient.breaker().entry(name);){
            Object object = inv.invoke();
            return object;
        }
        catch (BreakerException ex) {
            Context ctx = Context.current();
            if (ctx == null) throw ex;
            ctx.statusSet(429);
            ctx.setHandled(true);
            throw new DataThrowable((Throwable)ex);
        }
    }
}

