/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.impl;

import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.annotation.CloudBreaker;
import org.noear.solon.cloud.model.BreakerException;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Interceptor;
import org.noear.solon.core.handle.InterceptorChain;
import org.noear.solon.ext.DataThrowable;

public class CloudBreakerInterceptor
implements Interceptor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doIntercept(Object target, Object[] args, InterceptorChain chain) throws Throwable {
        CloudBreaker breaker = (CloudBreaker)chain.method().getAnnotation(CloudBreaker.class);
        if (CloudClient.breaker() == null) {
            throw new IllegalArgumentException("Missing CloudBreakerService component");
        }
        if (breaker == null) return chain.doIntercept(target, args);
        try (AutoCloseable entry = CloudClient.breaker().entry(breaker.value());){
            Object object = chain.doIntercept(target, args);
            return object;
        }
        catch (BreakerException ex) {
            Context ctx = Context.current();
            if (ctx == null) throw ex;
            ctx.statusSet(429);
            ctx.setHandled(true);
            throw new DataThrowable((Throwable)ex);
        }
    }
}

