/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud;

import org.noear.solon.Solon;

public class CloudProps {
    private String SERVER = "solon.cloud.@@.server";
    private String TOKEN = "solon.cloud.@@.token";
    private String USERNAME = "solon.cloud.@@.username";
    private String PASSWORD = "solon.cloud.@@.password";
    private String CONFIG_ENABLE = "solon.cloud.@@.config.enable";
    private String CONFIG_LOAD_GROUP = "solon.cloud.@@.config.loadGroup";
    private String CONFIG_LOAD_KEY = "solon.cloud.@@.config.loadKey";
    private String CONFIG_REFRESH_INTERVAL = "solon.cloud.@@.config.refreshInterval";
    private String DISCOVERY_ENABLE = "solon.cloud.@@.discovery.enable";
    private String DISCOVERY_HOSTNAME = "solon.cloud.@@.discovery.hostname";
    private String DISCOVERY_TAGS = "solon.cloud.@@.discovery.tags";
    private String DISCOVERY_HEALTH_CHECK_PATH = "solon.cloud.@@.discovery.healthCheckPath";
    private String DISCOVERY_HEALTH_CHECK_INTERVAL = "solon.cloud.@@.discovery.healthCheckInterval";
    private String DISCOVERY_HEALTH_DETECTOR = "solon.cloud.@@.discovery.healthDetector";
    private String DISCOVERY_REFRESH_INTERVAL = "solon.cloud.@@.discovery.refreshInterval";
    private String EVENT_ENABLE = "solon.cloud.@@.event.enable";
    private String EVENT_SEAL = "solon.cloud.@@.event.seal";

    public CloudProps(String frame) {
        this.SERVER = this.SERVER.replace("@@", frame);
        this.TOKEN = this.TOKEN.replace("@@", frame);
        this.USERNAME = this.USERNAME.replace("@@", frame);
        this.PASSWORD = this.PASSWORD.replace("@@", frame);
        this.CONFIG_ENABLE = this.CONFIG_ENABLE.replace("@@", frame);
        this.CONFIG_LOAD_GROUP = this.CONFIG_LOAD_GROUP.replace("@@", frame);
        this.CONFIG_LOAD_KEY = this.CONFIG_LOAD_KEY.replace("@@", frame);
        this.CONFIG_REFRESH_INTERVAL = this.CONFIG_REFRESH_INTERVAL.replace("@@", frame);
        this.DISCOVERY_ENABLE = this.DISCOVERY_ENABLE.replace("@@", frame);
        this.DISCOVERY_HOSTNAME = this.DISCOVERY_HOSTNAME.replace("@@", frame);
        this.DISCOVERY_TAGS = this.DISCOVERY_TAGS.replace("@@", frame);
        this.DISCOVERY_HEALTH_CHECK_PATH = this.DISCOVERY_HEALTH_CHECK_PATH.replace("@@", frame);
        this.DISCOVERY_HEALTH_CHECK_INTERVAL = this.DISCOVERY_HEALTH_CHECK_INTERVAL.replace("@@", frame);
        this.DISCOVERY_HEALTH_DETECTOR = this.DISCOVERY_HEALTH_DETECTOR.replace("@@", frame);
        this.DISCOVERY_REFRESH_INTERVAL = this.DISCOVERY_REFRESH_INTERVAL.replace("@@", frame);
        this.EVENT_ENABLE = this.EVENT_ENABLE.replace("@@", frame);
        this.EVENT_SEAL = this.EVENT_SEAL.replace("@@", frame);
    }

    public String getServer() {
        return Solon.cfg().get(this.SERVER);
    }

    public String getToken() {
        return Solon.cfg().get(this.TOKEN);
    }

    public String getUsername() {
        return Solon.cfg().get(this.USERNAME);
    }

    public String getPassword() {
        return Solon.cfg().get(this.PASSWORD);
    }

    public boolean getConfigEnable() {
        return Solon.cfg().getBool(this.CONFIG_ENABLE, true);
    }

    public String getConfigLoadGroup() {
        return Solon.cfg().get(this.CONFIG_LOAD_GROUP);
    }

    public String getConfigLoadKey() {
        return Solon.cfg().get(this.CONFIG_LOAD_KEY);
    }

    public String getConfigRefreshInterval(String def) {
        return Solon.cfg().get(this.CONFIG_REFRESH_INTERVAL, def);
    }

    public boolean getDiscoveryEnable() {
        return Solon.cfg().getBool(this.DISCOVERY_ENABLE, true);
    }

    public String getDiscoveryHostname() {
        return Solon.cfg().get(this.DISCOVERY_HOSTNAME);
    }

    public String getDiscoveryTags() {
        return Solon.cfg().get(this.DISCOVERY_TAGS);
    }

    public String getDiscoveryHealthCheckPath() {
        return Solon.cfg().get(this.DISCOVERY_HEALTH_CHECK_PATH, "/run/check/");
    }

    public String getDiscoveryHealthCheckInterval(String def) {
        return Solon.cfg().get(this.DISCOVERY_HEALTH_CHECK_INTERVAL, def);
    }

    public String getDiscoveryHealthDetector() {
        return Solon.cfg().get(this.DISCOVERY_HEALTH_DETECTOR);
    }

    public String getDiscoveryRefreshInterval(String def) {
        return Solon.cfg().get(this.DISCOVERY_REFRESH_INTERVAL, def);
    }

    public boolean getEventEnable() {
        return Solon.cfg().getBool(this.EVENT_ENABLE, true);
    }

    public String getEventSeal() {
        return Solon.cfg().get(this.EVENT_SEAL);
    }
}

