/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.tracing.integration;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.tracing.slf4j.TracingMDC;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class SolonFilterTracing
implements Filter {
    private Tracer tracer;
    private Set<String> excludePaths = new HashSet<String>();

    public SolonFilterTracing(String excluded) {
        Solon.context().getBeanAsync(Tracer.class, bean -> {
            this.tracer = bean;
        });
        if (Utils.isNotEmpty((String)excluded)) {
            for (String path : excluded.split(",")) {
                if ((path = path.trim()).length() <= 0) continue;
                if (path.startsWith("/")) {
                    this.excludePaths.add(path);
                    continue;
                }
                this.excludePaths.add("/" + path);
            }
        }
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (this.tracer == null || this.excludePaths.contains(ctx.pathNew())) {
            chain.doFilter(ctx);
        } else {
            Span span = this.buildSpan(ctx);
            try (Scope scope = this.tracer.activateSpan(span);){
                TracingMDC.inject(span);
                chain.doFilter(ctx);
            }
            catch (Throwable e) {
                span.log(Utils.throwableToString((Throwable)e));
                throw e;
            }
            finally {
                TracingMDC.removeSpanId();
                TracingMDC.removeTraceId();
                span.finish();
            }
        }
    }

    public Span buildSpan(Context ctx) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(ctx.pathNew()).append(" (").append(ctx.uri().getScheme()).append(" ").append(ctx.method()).append(')');
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName.toString());
        spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
        spanBuilder.withTag("req.url", ctx.url());
        SpanContext spanContext = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter((Map)ctx.headerMap()));
        if (spanContext != null) {
            spanBuilder = spanBuilder.asChildOf(spanContext);
        }
        Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter((Map)ctx.headerMap()));
        return span;
    }
}

