/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.net.URI;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.cloud.gateway.CloudRouteHandler;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.CompletableEmitter;
import org.noear.solon.util.KeyValues;

public class CloudRouteHandlerDefault
implements CloudRouteHandler {
    private WebClient httpClient;

    public CloudRouteHandlerDefault() {
        Solon.context().getBeanAsync(Vertx.class, b -> {
            WebClientOptions options = new WebClientOptions().setMaxPoolSize(250).setConnectTimeout(3000).setIdleTimeout(60).setKeepAlive(true).setKeepAliveTimeout(60);
            this.httpClient = WebClient.create((Vertx)b, (WebClientOptions)options);
        });
    }

    @Override
    public Completable handle(ExContext ctx) {
        try {
            HttpRequest<Buffer> req1 = this.buildHttpRequest(ctx);
            if (ctx.timeout() != null) {
                req1.connectTimeout((long)(ctx.timeout().getConnectTimeout() * 1000));
                req1.timeout((long)(ctx.timeout().getResponseTimeout() * 1000));
            }
            for (KeyValues<String> kv : ctx.newRequest().getHeaders().values()) {
                req1.putHeader(kv.getKey(), (Iterable)kv.getValues());
            }
            return Completable.create(emitter -> {
                if ("GET".equals(ctx.newRequest().getMethod())) {
                    req1.send(ar -> this.callbackHandle(ctx, (AsyncResult<HttpResponse<Buffer>>)ar, (CompletableEmitter)emitter));
                } else {
                    ctx.newRequest().getBody().onComplete(ar1 -> {
                        if (ar1.succeeded()) {
                            req1.sendBuffer((Buffer)ar1.result(), ar2 -> this.callbackHandle(ctx, (AsyncResult<HttpResponse<Buffer>>)ar2, (CompletableEmitter)emitter));
                        } else {
                            emitter.onError((Throwable)new StatusException(ar1.cause(), 400));
                        }
                    });
                }
            });
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Completable.error((Throwable)ex);
            }
            return Completable.error((Throwable)new StatusException(ex, 400));
        }
    }

    private HttpRequest<Buffer> buildHttpRequest(ExContext ctx) {
        URI targetUri;
        if ("lb".equals(ctx.target().getScheme())) {
            String tmp = LoadBalance.get((String)ctx.target().getHost()).getServer(ctx.target().getPort());
            if (tmp == null) {
                throw new StatusException("The target service does not exist", 404);
            }
            targetUri = URI.create(tmp);
        } else {
            targetUri = ctx.target();
        }
        if (targetUri.getPort() > 0) {
            return this.httpClient.request(HttpMethod.valueOf((String)ctx.newRequest().getMethod()), targetUri.getPort(), targetUri.getHost(), ctx.newRequest().getPathAndQueryString());
        }
        return this.httpClient.request(HttpMethod.valueOf((String)ctx.newRequest().getMethod()), targetUri.getHost(), ctx.newRequest().getPathAndQueryString());
    }

    private void callbackHandle(ExContext ctx, AsyncResult<HttpResponse<Buffer>> ar, CompletableEmitter subscriber) {
        try {
            if (ar.succeeded()) {
                HttpResponse resp1 = (HttpResponse)ar.result();
                ctx.newResponse().status(resp1.statusCode());
                for (Map.Entry kv : resp1.headers()) {
                    ctx.newResponse().headerAdd((String)kv.getKey(), (String)kv.getValue());
                }
                ctx.newResponse().body((Buffer)resp1.body());
                subscriber.onComplete();
            } else {
                subscriber.onError(ar.cause());
            }
        }
        catch (Throwable ex) {
            subscriber.onError(ex);
        }
    }
}

