/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.CompletableEmitter;
import org.noear.solon.rx.CompletableSubscriber;
import org.reactivestreams.Subscriber;

public class AddResponseHeaderFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "AddResponseHeader";
    }

    @Override
    public ExFilter create(String config) {
        return new AddResponseHeaderFilter(config);
    }

    public static class AddResponseHeaderFilter
    implements ExFilter {
        private final String name;
        private final String value;

        public AddResponseHeaderFilter(String config) {
            if (Utils.isBlank((String)config)) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config cannot be blank");
            }
            String[] parts = config.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config is wrong: " + config);
            }
            this.name = parts[0];
            this.value = parts[1];
            if (Utils.isEmpty((String)this.name) || Utils.isEmpty((String)this.value)) {
                throw new IllegalArgumentException("AddResponseHeaderFilter config is wrong: " + config);
            }
        }

        @Override
        public Completable doFilter(final ExContext ctx, ExFilterChain chain) {
            return Completable.create(emitter -> chain.doFilter(ctx).subscribe((Subscriber)new CompletableSubscriber((CompletableEmitter)emitter){
                final /* synthetic */ CompletableEmitter val$emitter;
                {
                    this.val$emitter = completableEmitter;
                }

                public void onError(Throwable throwable) {
                    ctx.newResponse().headerAdd(name, value);
                    this.val$emitter.onError(throwable);
                }

                public void onComplete() {
                    ctx.newResponse().headerAdd(name, value);
                    this.val$emitter.onComplete();
                }
            }));
        }
    }
}

