/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.integration;

import java.util.Collection;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.gateway.CloudRouteRegister;
import org.noear.solon.cloud.gateway.properties.DiscoverProperties;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.bean.LifecycleBean;

public class DiscoverLocator
implements LifecycleBean {
    private final CloudRouteRegister routeRegister;
    private final DiscoverProperties discover;

    public DiscoverLocator(DiscoverProperties discover, CloudRouteRegister routeRegister) {
        this.routeRegister = routeRegister;
        this.discover = discover;
    }

    public void start() {
        Collection serviceNames;
        if (Utils.isNotEmpty(this.discover.getIncludedServices())) {
            for (String tmp : this.discover.getIncludedServices()) {
                this.register(tmp);
            }
        }
        if (Utils.isNotEmpty((Collection)(serviceNames = CloudClient.discovery().findServices("")))) {
            for (String name : serviceNames) {
                this.register(name);
            }
        }
    }

    private void register(String serviceName) {
        if (this.discover.getExcludedServices().contains(serviceName)) {
            return;
        }
        this.routeRegister.route(serviceName, r -> r.path("/" + serviceName + "/**").target("lb://" + serviceName));
        LoadBalance.get((String)serviceName);
    }
}

